/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.css.core.internal.build;

import com.aptana.core.build.AbstractBuildParticipant;
import com.aptana.core.build.IProblem;
import com.aptana.core.logging.IdeLog;
import com.aptana.css.core.CSSCorePlugin;
import com.aptana.css.core.internal.build.Messages;
import com.aptana.index.core.build.BuildContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.w3c.css.css.StyleSheet;
import org.w3c.css.css.StyleSheetParser;
import org.w3c.css.parser.CssError;
import org.w3c.css.parser.CssErrorToken;
import org.w3c.css.parser.CssParseException;
import org.w3c.css.parser.Errors;
import org.w3c.css.properties.PropertiesLoader;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.Utf8Properties;
import org.w3c.css.util.Warning;
import org.w3c.css.util.Warnings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSValidator
extends AbstractBuildParticipant {
    public static final String ID = "com.aptana.css.core.W3CValidator";
    private static final String APTANA_PROFILE = "AptanaProfile";
    private static final String CONFIG_FILE = "AptanaCSSConfig.properties";
    private static final String PROFILES_CONFIG_FILE = "AptanaCSSProfiles.properties";
    private static final String[] CSS3_PROPERTIES = new String[]{"behavior", "box-shadow", "box-sizing", "column-count", "column-width", "column-gap", "column-rule", "border-radius", "background-clip", "background-origin", "background-quantity", "background-size", "border-top-right-radius", "border-bottom-right-radius", "border-bottom-left-radius", "border-top-left-radius", "font-family", "font-weight", "font-style", "outline-offset", "resize", "size", "src", "transform", "transition", "user-select", "word-break"};
    private static final String[] CSS3_AT_RULES = new String[]{"@namespace"};
    private static final String[] FILTERED_MESSAGES = new String[]{"unrecognized media only", "linear-gradient"};
    public static final String[] DEFAULT_FILTERS = new String[]{".*Unknown pseudo-element.*", "Property\\s*[-_].*doesn't exist.*", ".*-moz-.*", ".*-o-*", ".*opacity.*", ".*overflow-.*", ".*accelerator.*", ".*background-position-.*", ".*filter.*", ".*ime-mode.*", ".*layout-.*", ".*line-break.*", ".*page.*", ".*ruby-.*", ".*scrollbar-.*", ".*text-align-.*", ".*text-justify.*", ".*text-overflow.*", ".*text-shadow.*", ".*text-underline-position.*", ".*word-spacing.*", ".*word-wrap.*", ".*writing-mode.*", ".*zoom.*", ".*Parse Error.*", ".*-webkit-.*", ".*rgba.*is not a .* value.*", ".*Too many values or values are not recognized.*", Pattern.quote("Value Error : background (http://www.w3.org/TR/REC-CSS2/colors.html#propdef-background) , is an incorrect operator :")};

    static {
        CSSValidator.loadAptanaCSSProfile();
    }

    private void processErrorsInReport(Errors errors, String sourcePath, List<IProblem> items, List<String> filters) {
        CssError[] cssErrors;
        CssError[] cssErrorArray = cssErrors = errors.getErrors();
        int n = cssErrors.length;
        int n2 = 0;
        while (n2 < n) {
            String message;
            CssError cssError = cssErrorArray[n2];
            Throwable t = cssError.getException();
            String string = message = t == null ? "" : t.getMessage();
            if (cssError instanceof CssErrorToken) {
                CssErrorToken cet = (CssErrorToken)cssError;
                message = cet.getErrorDescription();
            } else if (t instanceof CssParseException) {
                message = "Parse Error";
            }
            int lineNumber = cssError.getLine();
            if (!(this.isIgnored(message, filters) || CSSValidator.containsCSS3Property(message) || CSSValidator.containsCSS3AtRule(message) || CSSValidator.isFiltered(message))) {
                items.add(this.createError(message, lineNumber, 0, 0, sourcePath));
            }
            ++n2;
        }
    }

    private void processWarningsInReport(Warnings warnings, String sourcePath, List<IProblem> items, List<String> filters) {
        Warning[] warningsArray;
        Warning[] warningArray = warningsArray = warnings.getWarnings();
        int n = warningsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Warning warning = warningArray[n2];
            String message = warning.getWarningMessage();
            if (!(this.isIgnored(message, filters) || CSSValidator.containsCSS3Property(message) || CSSValidator.containsCSS3AtRule(message) || CSSValidator.isFiltered(message))) {
                items.add(this.createWarning(message, warning.getLine(), 0, 0, sourcePath));
            }
            ++n2;
        }
    }

    private static void loadAptanaCSSProfile() {
        InputStream configStream = CSSValidator.class.getResourceAsStream(CONFIG_FILE);
        InputStream profilesStream = CSSValidator.class.getResourceAsStream(PROFILES_CONFIG_FILE);
        try {
            try {
                PropertiesLoader.config.load(configStream);
                Utf8Properties profiles = new Utf8Properties();
                profiles.load(profilesStream);
                Field field = PropertiesLoader.class.getDeclaredField("profiles");
                field.setAccessible(true);
                field.set(null, profiles);
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)CSSCorePlugin.getDefault(), (String)Messages.CSSValidator_ERR_FailToLoadProfile, (Throwable)e);
                try {
                    configStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    profilesStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                configStream.close();
            }
            catch (IOException iOException) {}
            try {
                profilesStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static StyleSheet getReport(String source, URI path) {
        StyleSheetParser parser = new StyleSheetParser();
        ApplContext ac = new ApplContext("en");
        ac.setProfile(APTANA_PROFILE);
        try {
            parser.parseStyleElement(ac, (InputStream)new ByteArrayInputStream(source.getBytes("UTF-8")), null, null, path.toURL(), 0);
        }
        catch (MalformedURLException e) {
            IdeLog.logError((Plugin)CSSCorePlugin.getDefault(), (String)MessageFormat.format(Messages.CSSValidator_ERR_InvalidPath, path), (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            IdeLog.logError((Plugin)CSSCorePlugin.getDefault(), (Throwable)e);
        }
        StyleSheet stylesheet = parser.getStyleSheet();
        stylesheet.findConflicts(ac);
        return stylesheet;
    }

    private static boolean containsCSS3Property(String message) {
        String[] stringArray = CSS3_PROPERTIES;
        int n = CSS3_PROPERTIES.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            if (message.indexOf("Property " + property) > -1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean containsCSS3AtRule(String message) {
        String[] stringArray = CSS3_AT_RULES;
        int n = CSS3_AT_RULES.length;
        int n2 = 0;
        while (n2 < n) {
            String rule = stringArray[n2];
            if (message.indexOf(MessageFormat.format("the at-rule {0} is not implemented", rule)) > -1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isFiltered(String message) {
        String[] stringArray = FILTERED_MESSAGES;
        int n = FILTERED_MESSAGES.length;
        int n2 = 0;
        while (n2 < n) {
            String filtered = stringArray[n2];
            if (message.indexOf(filtered) > -1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void buildFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        ArrayList<IProblem> problems = new ArrayList<IProblem>();
        String source = context.getContents();
        URI uri = context.getURI();
        String path = uri.toString();
        StyleSheet sheet = CSSValidator.getReport(source, uri);
        List filters = this.getFilters();
        this.processErrorsInReport(sheet.getErrors(), path, problems, filters);
        this.processWarningsInReport(sheet.getWarnings(), path, problems, filters);
        context.putProblems("com.aptana.editor.css.w3c_problem", problems);
    }

    public void deleteFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        context.removeProblems("com.aptana.editor.css.w3c_problem");
    }
}

